import { tassign } from 'tassign';
import {
  BOOKMARK_ICON_FOCUSED,
  BOOKMARK_ICON_UNFOCUSED,
  SEARCH_ICON_FOCUSED,
  SEARCH_ICON_UNFOCUSED,
  UPDATE_ACTIVE_ICON,
} from '../actions';

function setBookmarkIconFocus(state, action) {
  return tassign(state, {isBookmarkIconFocus: true});
}
function setBookmarkIconUnFocus(state, action) {
  return tassign(state, {isBookmarkIconFocus: false});
}
function setSearchIconFocus(state, action) {
  return tassign(state, {isSearchIconFocus: true});
}
function setSearchIconUnFocus(state, action) {
  return tassign(state, {isSearchIconFocus: false});
}
function updateActiveIcon(state, action) {
  return tassign(state, {activeIcon: action.payload});
}

const INITIAL_STATE = {
  isBookmarkIconFocus: false,
  isSearchIconFocus: false,
  activeIcon: 'conceptSearchIcon',
};
export default function sideNavigationReducer(state=INITIAL_STATE, action) {
  switch (action.type) {
    case SEARCH_ICON_FOCUSED:
      return setSearchIconFocus(state, action);
    case BOOKMARK_ICON_FOCUSED:
      return setBookmarkIconFocus(state, action);
    case UPDATE_ACTIVE_ICON:
      return updateActiveIcon(state, action);
  }
  return state;
}